{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:35:44 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  {$IFDEF WIN32}
  Windows,
  {$ELSE}
  WinProcs,
  WinTypes,
  {$ENDIF}
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  Buttons,
  MMSystem,
  MMUtils,
  MMObj,
  MMDSPObj,
  MMPcmSup,
  MMFXGen,
  MMWavOut,
  MMConect,
  MMDesign,
  MMSlider,
  MMDIBCv,
  MMSpGram,
  MMFIR,
  MMHTimer,
  MMHook;
  
type
  TMainForm = class(TForm)
    MMDesigner1: TMMDesigner;
    Connector: TMMConnector;
    StopBtn: TBitBtn;
    StartBtn: TSpeedButton;
    WaveOut: TMMWaveOut;
    MMSpectrogram1: TMMSpectrogram;
    Generator: TMMGenerator;
    slAmp: TMMSlider;
    slFreq: TMMSlider;
    GroupBox2: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    Label2: TLabel;
    Label4: TLabel;
    FIRFilter: TMMFIRFilter;
    HiTimer: TMMHiTimer;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure StartBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure WaveStop(Sender: TObject);
    procedure WaveStart(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RadioButtonClick(Sender: TObject);
    procedure slFreqChange(Sender: TObject);
    procedure slAmpChange(Sender: TObject);
    procedure HiTimerTimer(Sender: TObject);
  private
  public
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

type
     TFilter  = record
       Freq: FLoat;  { frequency in Hz }
       Amp : Float;  { amplitude in dB }
     end;

     PFilterArray = ^TFilterArray;
     TFilterArray = array[0..0] of TFilter;

(******************************************************************************)

     {=================================}
     { a simple 1000 Hz Lowpass Filter }
     {=================================}
     {                                 }
     {   |f1       f2                  }
     {   |++++++++++                   }
     {   |         +                   }
     {   |         +                   }
     {  -|---------+++++++++++++       }
     {            f3           f4      }
     {=================================}
const
     nLPoints = 4;
     LowPass : array[0..nLPoints-1] of TFilter =
      ((Freq:  0;    Amp: 0),     { f1 }
       (Freq:  1000; Amp: 0),     { f2 }
       (Freq:  1001; Amp: -90),   { f3 }
       (Freq: 22050; Amp: -90));  { f4 }

(******************************************************************************)

     {=================================}
     { a simple 1000 Hz Highpass Filter}
     {=================================}
     {                                 }
     {   |         f3          f4      }
     {   |         +++++++++++++       }
     {   |         +                   }
     {   |         +                   }
     {  -|++++++++++------------       }
     {   f1       f2                   }
     {=================================}
const
     nHPoints = 4;
     HighPass : array[0..nHPoints-1] of TFilter =
      ((Freq:  0;    Amp: -90),   { f1 }
       (Freq:  1000; Amp: -90),   { f2 }
       (Freq:  1001; Amp:   0),   { f3 }
       (Freq: 22050; Amp:   0));  { f4 }

(******************************************************************************)

     {=================================}
     { a simple 1000-5000 Hz Bandpass  }
     {=================================}
     {                                 }
     {   |      f3        f4           }
     {   |      +++++++++++            }
     {   |      +         +            }
     {   |      +         +            }
     {  -|+++++++---------+++++++      }
     {   f1     f2        f5    f6     }
     {=================================}
const
     nBPoints = 6;
     BandPass: array[0..nBPoints-1] of TFilter =
      ((Freq:  0;    Amp: -90),   { f1 }
       (Freq:  1000; Amp: -90),   { f2 }
       (Freq:  1001; Amp:   0),   { f3 }
       (Freq:  5000; Amp:   0),   { f4 }
       (Freq:  5001; Amp: -90),   { f5 }
       (Freq: 22050; Amp: -90));  { f6 }

(******************************************************************************)

     {=================================}
     { a simple 1000-5000 Hz Bandstop  }
     {=================================}
     {                                 }
     {   |f1    f2        f5     f6    }
     {   |+++++++         ++++++++     }
     {   |      +         +            }
     {   |      +         +            }
     {  -|------+++++++++++-------     }
     {          f3        f4           }
     {=================================}
const
     nSPoints = 6;
     BandStop: array[0..nSPoints-1] of TFilter =
      ((Freq:  0;    Amp:   0),   { f1 }
       (Freq:  1000; Amp:   0),   { f2 }
       (Freq:  1001; Amp: -90),   { f3 }
       (Freq:  5000; Amp: -90),   { f4 }
       (Freq:  5001; Amp:   0),   { f5 }
       (Freq: 22050; Amp:   0));  { f6 }

(******************************************************************************)

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
var
   i,n: integer;
   p: PFilterArray;
   FilterTyp: integer;

begin
   { a simple example how to setup the Filter at runtime }

   { change this value to 0..3 to change the filter }
   FilterTyp := 0;

   { select the filter params }
   case FilterTyp of
       0: begin
             p := @LowPass;
             n := nLPoints;
          end;
       1: begin
             p := @HighPass;
             n := nHPoints;
          end;
       2: begin
             p := @BandPass;
             n := nBPoints;
          end;
       3: begin
             p := @BandStop;
             n := nSPoints;
          end;
   end;

   { first clear all previous filters }
   FIRFilter.Filters.FreeAll;

   { setup the Filter }
   with FIRFilter do
   for i := 0 to n-1 do
   with p[i] do
   begin
      Filters.AddObject(TMMFIRFilterItem.CreateEx(Freq,Amp));
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.StartBtnClick(Sender: TObject);
begin
   if not (wosPlay in WaveOut.State) then
   begin
      WaveOut.Start;
      HiTimer.Enabled := True;
   end;

   StartBtn.Down := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.StopBtnClick(Sender: TObject);
begin
   WaveOut.Stop;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveOut.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveStop(Sender: TObject);
begin
   HiTimer.Enabled := False;
   WaveOut.Close;
   StopBtn.Enabled := False;
   StartBtn.Down := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.WaveStart(Sender: TObject);
begin
   StopBtn.Enabled := True;
   StartBtn.Down := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.RadioButtonClick(Sender: TObject);
begin
   if Sender = RadioButton1 then
      Generator.WaveForm := wfSine
   else if Sender = RadioButton2 then
      Generator.WaveForm := wfSquare
   else if Sender = RadioButton3 then
      Generator.WaveForm := wfTriangle
   else
      Generator.WaveForm := wfNoise;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.slFreqChange(Sender: TObject);
begin
   Generator.Frequency := slFreq.Position;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.slAmpChange(Sender: TObject);
begin
   Generator.Amplitude := slAmp.Position;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.HiTimerTimer(Sender: TObject);
begin
   { we use the manual trigger mode for a smooth display (set AutoTrigger to False) }
   Connector.Trigger;
end;

end.
